

class SplitData:
    def __init__(self):
        self.marks = set()
        self.incoming_transitions = {}
        self.state_label = None

    def mark(self, label: bool) -> bool:
        """Mark this node with the given label and return whether it was newly marked."""
        return self.marks.add(label) is None  # In Python, set.add() doesn't return a value. We adjust the logic accordingly.

    def has_state_label(self) -> bool:
        """Check if there is a state label associated with this node."""
        return self.state_label is not None

    def set_state_label(self, label: bool):
        """Set the state label. Asserts if a label has already been set."""
        assert not self.has_state_label(), "A state label has already been set."
        self.state_label = label

    def get_state_label(self) -> bool:
        """Get the state label. Asserts if no label has been set."""
        assert self.has_state_label(), "No state label has been set."
        return self.state_label

    def get_incoming(self, label: bool):
        """Retrieve the list of incoming transitions for the respective label."""
        if label not in self.incoming_transitions:
            from incoming_list import IncomingList  # Assuming IncomingList is defined elsewhere
            self.incoming_transitions[label] = IncomingList()
        return self.incoming_transitions[label]

    def is_marked(self, label: bool) -> bool:
        """Check if the corresponding node is marked with the given label."""
        return label in self.marks
